/**
 * Created by lei.wang_1 on 2016/6/22.
 */
appModule.directive("noticeUeEditor", ["api", "utils", "$translate", "log", "notices", "$timeout", function (api, utils, translate, log, notices, $timeout) {
    return {
        template: `<script id="container" name="content" type="text/plain"></script>'
                   <insert-video-panel on-cancel="closeVideoPanel()" on-complete="onVideoInput(url,name)" is-show="isShowVideo"></insert-video-panel>`,
        restrict: "E",
        scope: {
            content: "=",
            placeHolder: "=",
            allCloud: "=",
            openCloud: "&",
            openMultipleImagesUpload: "&",
            showFile: "=",
            showUeditorLoading:"&",
            hideUeditorLoading:"&"
        },
        link: function ($scope, element) {
            var IMAGE_MAX_SIZE = 1024 * 1024;
            $scope.pasteTimeout = null;
            var ue = UE.getEditor('container', {
                toolbars: [[
                    'undo', '|',
                    'fontsize', 'forecolor', '|',
                    'bold', 'italic', 'underline', '|',
                    'justifyleft', 'justifycenter', 'justifyright', '|',
                    'insertorderedlist', 'insertunorderedlist', '|',
                    'link', '|',
                    'blockquote', 'horizontal', '|',
                    'inserttable', 'deletetable', 'insertparagraphbeforetable', 'insertrow', 'deleterow', 'insertcol', 'deletecol', 'mergecells', 'mergeright', 'mergedown', 'splittocells', 'splittorows', 'splittocols'
                ]],
                insertorderedlist: {
                    'decimal': '1,2,3...',
                    'lower-alpha': '', // 'a,b,c...'
                    'lower-roman': '', //'i,ii,iii...'
                    'upper-alpha': '', //'A,B,C'
                    'upper-roman': '' //'I,II,III...'
                },
                insertunorderedlist: {
                    'circle': '', // '○ 小圆圈'
                    'disc': '', // '● 小圆点'
                    'square': '' //'■ 小方块'
                },
                serverUrl: "",
                autoHeightEnabled: true,
                autoFloatEnabled: true,
                elementPathEnabled: false,
                wordCount: false,
                enableAutoSave: false,
                initialFrameWidth: 539,
                sourceEditor: 'textarea',
                lang: utils.getCurrentLanguage() == 'zh-cn' ? 'zh-cn' : 'en'
            });
            var initCount = 17;
            //------------------------------云盘--------------------------------//
            if ($scope.allCloud) {
                UE.registerUI('cloud', function (editor, uiName) {
                    //注册按钮执行时的command命令，使用命令默认就会带有回退操作
                    editor.registerCommand(uiName, {
                        execCommand: function () {
                            $scope.openCloud();
                        }
                    });

                    //创建一个button
                    var btn = new UE.ui.Button({
                        //按钮的名字
                        name: uiName,
                        //提示
                        title: translate.instant('publish.editor.cloud'),
                        cssRules: 'background-position: -622px -40px;',
                        //点击时执行的命令
                        onclick: function () {
                            //这里可以不用执行命令,做你自己的操作也可
                            editor.execCommand(uiName);
                        }
                    });

                    //返回云盘链接
                    return btn;
                }, initCount++);
            }

            //处理云盘返回的文件JSON对象
            var offCloudFileSelected = $scope.$on("onCloudFileSelected", function (event, args) {
                if (!args) {
                    return;
                }

                var iconURL = args.fileIcon;
                var size = args.filesize;
                var division = 1024, unit = "KB";
                if (size > division * division) {
                    division *= division;
                    unit = "MB";
                }
                size = (size / division).toFixed(2) + unit;
                delete args.fileIcon;

                drawCloudFile(iconURL, args.filename, translate.instant("publish.editor.size") + size, function (url) {
                    var base64data = utils.utf8ToBase64(JSON.stringify(args));
                    var href = "http://gnet-uc-native.quanshi.com?act=cloudFileDownload&data=" + base64data;
                    var anchor = "<a href='" + href + "' target='_blank' class='cloudFile' title='" + args.filename + "'>"
                        + "<img src='" + url + "' />"
                        + "</a>";
                    ue.execCommand('insertHtml', anchor, true);
                });
            });

            function drawCloudFile(imageURL, fileName, fileSize, callback) {
                var canvas = document.createElement("canvas");
                canvas.width = "300";
                canvas.height = "96";
                var ctx = canvas.getContext("2d");
                var image = new Image();
                image.onload = function () {
                    ctx.drawImage(image, 20, 25, 40, 40);
                    ctx.font = "12px 微软雅黑";
                    ctx.fillText(adjustFillText(ctx, fileName, 200), 80, 35);
                    ctx.fillText(fileSize, 80, 60);
                    callback(canvas.toDataURL());
                };
                image.src = imageURL;
            }

            function adjustFillText(ctx, text, limit) {
                var surfix = "...";
                var newText = text;
                while (ctx.measureText(newText + surfix).width > limit) {
                    newText = newText.slice(0, newText.length - 1);
                }
                if (newText < text) {
                    newText += surfix;
                }
                return newText;
            }

            //-----------------------------------------------------------------//
            //-----------------------------图片-------------------------------//
            if($scope.showFile){
                $scope.insertImages = function (data) {
                    if (data.errorCode === 0) {
                        if (data.paths && data.paths.length > 0) {
                            data.paths.forEach(function (path) {
                                ue.execCommand("insertHtml", "<p><img src='" + path + "'/></p>", true);
                            });
                        }
                    } else {
                        api.notifyError(data.msg);
                    }
                };

                $scope.uploadOneImage = function (data) {
                    if (data.errorCode === 0 && data.paths[0]) {
                        var promise = utils.uploadOneFile(data.paths[0]);
                        promise.then(function (result) {
                            if (result.code === 0) {
                                ue.execCommand("insertHtml", "<p><img src='" + result.data.url + "'/></p>", true);
                            }
                        });
                    } else {
                        api.notifyError(data.msg);
                    }
                };

                UE.registerUI('upload_image', function (editor, uiName) {
                    //注册按钮执行时的command命令，使用命令默认就会带有回退操作
                    editor.registerCommand(uiName, {
                        execCommand: function () {
                            utils.openImageDialog(function (data) {
                                $scope.uploadOneImage(data);
                            }, IMAGE_MAX_SIZE, false); //大图会导致CEF 无响应，暂时设置1M
                        }
                    });

                    //创建一个button
                    var btn = new UE.ui.Button({
                        //按钮的名字
                        name: uiName,
                        //提示
                        title: translate.instant('publish.editor.image'),
                        cssRules: 'background-position: -380px 0;',
                        onclick: function () {
                            editor.execCommand(uiName);
                        }
                    });

                    //返回上传图片
                    return btn;
                }, initCount++);

                UE.registerUI('upload_images', function (editor, uiName) {
                    //注册按钮执行时的command命令，使用命令默认就会带有回退操作
                    editor.registerCommand(uiName, {
                        execCommand: function () {
                            $scope.openMultipleImagesUpload({callback: $scope.insertImages});
                        }
                    });

                    //创建一个button
                    var btn = new UE.ui.Button({
                        //按钮的名字
                        name: uiName,
                        //提示
                        title: translate.instant('publish.editor.images'),
                        cssRules: 'background-position: -726px -77px;',
                        //点击时执行的命令
                        onclick: function () {
                            //这里可以不用执行命令,做你自己的操作也可
                            editor.execCommand(uiName);
                        }
                    });

                    //返回上传图片
                    return btn;
                }, initCount++);

                UE.plugins["droppasteimage"] = function () {
                    this.addListener('drop', function (eventName, e) {
                        utils.getDropImages(function (data) {
                            $scope.uploadOneImage(data);
                        }, IMAGE_MAX_SIZE);
                    });
                    this.addListener('beforepaste', function (eventName, html) {
                        if (html) { //将复制的云盘链接多余的斜杠替换回来
                            html.html = html.html.replace(/http:\/\/gnet-uc-native.quanshi.com\/\?act=cloudFileDownload/g, 'http://gnet-uc-native.quanshi.com?act=cloudFileDownload');
                        }
                    });
                    this.addListener('afterpaste', function (eventName, pasteData) {
                        if ($scope.pasteTimeout) {
                            $timeout.cancel($scope.pasteTimeout);
                        }
                        if (pasteData) { //如果粘贴内容存在 就表明非截图
                            return;
                        }
                        $scope.pasteTimeout = $timeout(function () {
                            var data = utils.getClipboardData();
                            if (!data) {
                                return null;
                            }

                            if (data.format === "CF_BITMAP") {
                                if (data.items && data.items.length > 0) {

                                    var images = [];
                                    var item = data.items[0];
                                    if (utils.isFileExist(item)) {
                                        var isValid = utils._handleImage(item);
                                        if(isValid.error){
                                            images.push(item);
                                        }else {
                                            log.logInfo('clipped image too large to paste: ' + size);
                                        }
                                    } else {
                                        log.logInfo('can\'t find clipped image: ' + item);
                                    }
                                    if (images.length > 0) {
                                        $scope.uploadOneImage({
                                            errorCode: 0,
                                            paths: images
                                        });
                                    }
                                }
                            }
                        }, 50);

                        return false;
                    });
                };
            }

            var offImageUpload = $scope.$on("onLocalImageStartUpload", function () {
                var contentHtml = ue.getContent();
                notices.uploadEditorImages(contentHtml, function (code, message, html) {
                    utils.applyScope($scope, function () {
                        if (contentHtml != html) {
                            ue.setContent(html);
                        }
                        $scope.$emit("onLocalImagesUploaded", {
                            "errorCode": code,
                            "errorMessage": message,
                            "data": html
                        });
                    });
                });
            });

            //---------------------------------------------------------------------------------//
            //-----------------------------音频------------------------------------------------//
            if($scope.showFile) {
                UE.registerUI('bbs_audio', function (editor, uiName) {
                    //注册按钮执行时的command命令，使用命令默认就会带有回退操作
                    editor.registerCommand(uiName, {
                        execCommand: function () {
                           
                            utils.openFileDialog(function (result) {
                                log.logInfo('selected audio file result ' + JSON.stringify(result));
                                if (result.errorCode == 0) {
                                    utils.applyScope($scope, function () {
                                        $scope.showUeditorLoading();
                                    });
                                    var promise = utils.uploadOneFile(result.filesInfo[0].url, null);
                                    promise.then(function (res) {
                                        $scope.hideUeditorLoading();
                                        log.logInfo('upload audio file result ' + JSON.stringify(res));
                                        if (res.code == 0) {
                                            ue.execCommand("insertHtml", `<p>
                                            <audio id="bbs_audio" controls>
                                                <source type="audio/mpeg" src="${res.data.url}"/>
                                            </audio>
                                            <br/>
                                          </p>`, true);
                                        }
                                    });
                                }
                            }, null, false, '*.mp3');
                        }
                    });

                    //创建一个button
                    var btn = new UE.ui.Button({
                        //按钮的名字
                        name: uiName,
                        //提示
                        title: translate.instant('publish.editor.audio'),
                        cssRules: 'background-position: -18px -40px;',
                        //点击时执行的命令
                        onclick: function () {
                            //这里可以不用执行命令,做你自己的操作也可
                            editor.execCommand(uiName);
                        }
                    });
                    editor.addListener('contentChange', function () {
                        var $content = $(utils.removeMediaAttributes(this.getContent()));
                        if ($content.find('audio').length > 0) {
                            btn.setDisabled(true);
                        } else {
                            btn.setDisabled(false);
                        }
                    });
                    //返回音频
                    return btn;
                }, initCount++);
            }
            //--------------------------------------------------------------------------------//
            //-----------------------------视频------------------------------------------------//
            UE.registerUI('bbs_video', function (editor, uiName) {
                //注册按钮执行时的command命令，使用命令默认就会带有回退操作
                editor.registerCommand(uiName, {
                    execCommand: function () {
                        utils.applyScope($scope, function () {
                            $scope.isShowVideo = true;
                        });
                    }
                });

                //创建一个button
                var btn = new UE.ui.Button({
                    //按钮的名字
                    name: uiName,
                    //提示
                    title: translate.instant('publish.editor.video.name'),
                    cssRules: 'background-position: -320px -20px',
                    //点击时执行的命令
                    onclick: function () {
                        editor.execCommand(uiName);
                    }
                });

                //返回视频
                return btn;
            }, initCount++);

            $scope.onVideoInput = function (url, name) {
                try{
                    var p = window.fetch(url);
                    p.then(function (response) {
                        if (response.ok) {
                            var contentType = response.headers.get('Content-Type');
                            if (contentType == 'video/mp4') { //判断媒体类型，如果不是mp4，显示警告
                                $scope.insertVideo(url, name);
                                log.logInfo('video is '+url);
                                return;
                            }
                        }
                        $scope.insertError();
                    });
                    p.catch(function(){
                        $scope.insertError();
                    });
                }catch(e){
                    $scope.insertError();
                }
            };

            $scope.insertVideo = function (url, name) {
                var videoId = "bbs_video_" + Date.now();
                //显示提示信息
                ue.execCommand("insertHtml", `<p class="videoWrapper">
<span class="videoName" style="display:block;font-size: 12px;line-height: 1.5;display:block;color:#3399f3;">${name}</span>
<video id="${videoId}" preload="auto" style="max-width:100%; background-color: #000;" controls><source type="video/mp4" src="${url}"/>
</video></p><br />`, true);
                var video = ue.document.getElementById(videoId);
                if (video) {
                    video.onloadeddata = function () {
                        log.logInfo('video onloadeddata ');
                        //加载第一帧作为封面
                        video.setAttribute('poster', utils.getVideoPoster(video));
                        video.setAttribute('style', 'max-width:100%;width:' + video.videoWidth + 'px;height:auto');
                    };
                    video.addEventListener('error', function () {
                        //显示提示信息
                        log.logInfo('video error ');
                        var videoRoot = video.parentNode;
                        videoRoot.querySelector('.videoName').remove();
                        video.remove();
                        var warning = document.createElement('span');
                        warning.className = "videoWarning";
                        warning.innerText = translate.instant('publish.editor.video.error-message');
                        videoRoot.appendChild(warning);
                    }, true);
                }
            };

            $scope.insertError = function(){
                var warningText = translate.instant('publish.editor.video.error-message');
                ue.execCommand("insertHtml", `<p class="videoWrapper"><span class="videoWarning" contenteditable="false">${warningText}</span></p>`, true);
            };

            $scope.closeVideoPanel = function () {
                $scope.isShowVideo = false;
            };
            //--------------------------------------------------------------------------------//
            var offloadContentStart = $scope.$on("loadContentStart", function (e, callback) {
                $scope.$emit("contentLoaded", ue.getContent(), callback);
            });

            var offContentReady = $scope.$on("ContentReady", function (e, content) {
                log.logInfo('publish content is ready...');
                if ($scope.editorIsReady) {
                    ue.setContent(content);
                } else {
                    $scope.initContent = content;
                    $scope.contentIsReady = true;
                }
            });

            ue.addListener("contentChange", function (e) {
                utils.applyScope($scope, function () {
                    $scope.content = ue.getContent();
                });
            });

            ue.addListener("ready", function () {
                element.next('#temp-container').remove();
                ue.execCommand('fontsize', '14px'); //设置默认字体为14px
                log.logInfo('ueditor is ready...');
                if ($scope.contentIsReady) {
                    ue.setContent($scope.initContent);
                } else {
                    $scope.editorIsReady = true;
                }
            });
            //---------------------------------------------------------------------------------//


            $scope.$on("$destroy", function () {
                offImageUpload();
                offContentReady();
                offCloudFileSelected();
                offloadContentStart();
            });
        }
    };
}]);